/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	HideOtherSketches.cpp

#include <stdafx.h>

#include "cUtility.h"
#include "CWorkplane.h"
#include "cApplication.h"

// Hide all Sketches except the active One.
HRESULT HideOtherSketches()
{
	START_METHOD("HideOtherSketches")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IDesign *design = NULL;
	status = activePart->GetDesign(&design);
	CHECK_RETURN_STATUS(status)

	ISet *workplaneSet= NULL;
	status = design->GetWorkplanes(&workplaneSet);
	CHECK_RETURN_STATUS(status)

	long count;
	status = workplaneSet->GetCount(&count);
	CHECK_RETURN_STATUS(status)

	IIt *pObjectIt = NULL;
	status = (GetCLASS(It))->CreateAObjectIt(workplaneSet,&pObjectIt);
	CHECK_RETURN_STATUS(status)

	// Iterate through all the available workplanes and sketches
    // and hide all the sketches except the active sketch.
	IDispatch *pCurrentWorkplane= NULL;
	pObjectIt->start(&pCurrentWorkplane);
	while (pCurrentWorkplane) {
		// Get the total number of sketches
		IWorkplane *currentWorkplane = CAST(IWorkplane, pCurrentWorkplane);
		
		ISet *sketchSet1 = NULL;
		status = currentWorkplane->GetSketches(&sketchSet1);
		if(!sketchSet1)
			continue;
		
		long sketchCount;
		status = sketchSet1->GetCount(&sketchCount);
		CHECK_RETURN_STATUS(status)
    
		IIt *pObjectIt2 = NULL;
		status = (GetCLASS(It))->CreateAObjectIt(sketchSet1,&pObjectIt2);
		CHECK_RETURN_STATUS(status)

		IDispatch *psk=NULL;
		pObjectIt2->start(&psk);
        while (psk) {
			ISketch *sketch1 = CAST(ISketch, psk);
  		    
			status = sketch1->SetVisible(FALSE);
			CHECK_RETURN_STATUS(status)

  			psk = NULL;
			pObjectIt2->Next(&psk);
		}
	pCurrentWorkplane = NULL;
	pObjectIt->Next(&pCurrentWorkplane);
	}  
	
	status = activeSketch->SetVisible(TRUE);
	CHECK_RETURN_STATUS(status)
  	
	END_METHOD("HideOtherSketches");
}
